//------------------------------------------------------------------------------------------------------------------------------------------------
// PA2 Extras - EMC Mapper
//------------------------------------------------------------------------------------------------------------------------------------------------
// Author: RicTheCoder
//
// This script is designed to enforce EMC mapping, it runs the emc command on server load to enforce values, this also prevents the config from
// bugging and a new one being generated and deleting all changes.
//------------------------------------------------------------------------------------------------------------------------------------------------

// EMC Mapper
// - Key is the Item ID and the Value is the EMC Value to set
// - This is more dynamic than changing the config always, and should force-fix some conflicts
// - Tags are allowed when prefixed by '#'
const emcMapper = {
	// Regions Unexplored
	"regions_unexplored:prismoss": 2,
	"regions_unexplored:deepslate_prismoss": 3,
	"regions_unexplored:silt_mud": 1,
	"regions_unexplored:peat_mud": 1,
	"regions_unexplored:peat_podzol": 2,
	"regions_unexplored:silt_podzol": 2,
	"regions_unexplored:prismarite_cluster": 4,
	"regions_unexplored:volcanic_ash": 1,

    // Cyclic
    "cyclic:glass_connected": 1,

    // Twigs
    "twigs:bloodstone": 2,
    "twigs:pebble": 1,
    "twigs:rocky_dirt": 1,

    // Spelunker's Charm
    "spelunkers_charm:deepslate_rock": 1,
	
	// Ecologics
	"ecologics:seashell": 16,
	
	// Apotheosis
	"apotheosis:weapon_tome": 389,
	"apotheosis:scrap_tome": 1024,
	
	// Applied Energistics
	"ae2:cable_anchor": 36,
	"ae2:blank_pattern": 1024,
	
	// Supplementaries
	"supplementaries:bunting{Color:\"white\"}": 0,
	"supplementaries:bunting{Color:\"light_gray\"}": 0,
	"supplementaries:bunting{Color:\"gray\"}": 0,
	"supplementaries:bunting{Color:\"black\"}": 0,
	"supplementaries:bunting{Color:\"brown\"}": 0,
	"supplementaries:bunting{Color:\"red\"}": 0,
	"supplementaries:bunting{Color:\"orange\"}": 0,
	"supplementaries:bunting{Color:\"yellow\"}": 0,
	"supplementaries:bunting{Color:\"lime\"}": 0,
	"supplementaries:bunting{Color:\"green\"}": 0,
	"supplementaries:bunting{Color:\"cyan\"}": 0,
	"supplementaries:bunting{Color:\"light_blue\"}": 0,
	"supplementaries:bunting{Color:\"blue\"}": 0,
	"supplementaries:bunting{Color:\"purple\"}": 0,
	"supplementaries:bunting{Color:\"magenta\"}": 0,
	"supplementaries:bunting{Color:\"pink\"}": 0
};

//---[CODE]---------------------------------------------------------------------------------------------------------------------------------------

// Mapper version to prevent re-injection
const emcVer = 4;

// Server loading to apply the EMC commands
ServerEvents.loaded(event => {
	// Get Constants
	const data = event.server.getPersistentData();
	if (data.contains("pa2_emcver") && data.getInt("pa2_emcver") == emcVer)
		return;
	
	// Set version
	data.putInt("pa2_emcver", emcVer);
	
	// Apply Mappings
	Object.keys(emcMapper).forEach(item => {
		let value = emcMapper[item];
		event.server.runCommandSilent(`projecte setemc ${value} ${item}`);
	});
	
	// Warns the mappings were applied and locks it
	console.log("Applied dynamic EMC mappings");
});